%% DMSO, PHA, SNS
values=[0.862565	0.988113	0.457228	1.246857	0.761363	1.135416; 
    0.510714	1.096868	0.52829	1.049715	0.74617	1.155632;
    0.78442	1.126549	0.518285	1.105696	0.805137	1.634515];

value_mean = mean(values, 2);
value_err = tinv(0.975,5)*std(values,1, 2)/sqrt(6);

normFac = value_mean(1);
value_err = value_err/normFac;
value_mean = value_mean/normFac;
values = values/normFac;

figure; % main
b=bar(1:2,value_mean([1 3])); b.FaceColor='flat'; b(1).CData=[1 1 1]*.8; hold on;
errorbar(1:2,value_mean([1 3]),value_err([1 3]),'color','k','linestyle','none'); ylim([0 1.51])
scatter(1+randn(6,1)*0.15, values(1,:), 12, [1 1 1]*.3, 'filled','MarkerFaceAlpha',.5)
scatter(2+randn(6,1)*0.15, values(3,:), 12, [1 1 1]*.3, 'filled','MarkerFaceAlpha',.5)
set(gca,'xtick',1:2,'xticklabel',{'Control','SNS'},'fontsize',16,'ytick',0:0.5:1.5);
ylabel('Relative PSMB5 Conc.'); box off

figure; % supp
b=bar(1:3,value_mean); b.FaceColor='flat'; b(1).CData=[1 1 1]*.8; hold on;
errorbar(1:3,value_mean,value_err,'color','k','linestyle','none'); ylim([0 1.51])
scatter(1+randn(6,1)*0.15, values(1,:), 12, [1 1 1]*.3, 'filled','MarkerFaceAlpha',.5)
scatter(2+randn(6,1)*0.15, values(2,:), 12, [1 1 1]*.3, 'filled','MarkerFaceAlpha',.5)
scatter(3+randn(6,1)*0.15, values(3,:), 12, [1 1 1]*.3, 'filled','MarkerFaceAlpha',.5)
set(gca,'xtick',1:3,'xticklabel',{'Control','PFA','SNS'},'fontsize',16,'ytick',0:0.5:1.5);
ylabel('Relative PSMB5 Conc.'); box off
